using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace SPStudio
{
	/// <summary>
	/// A window that displays
	/// all of the images associated
	/// with the workspace.
	/// Clicking on an image name
	/// will activate the corresponding
	/// ImageContainer.
	/// </summary>
	public class ImageList : System.Windows.Forms.Form
	{
		#region Public Vars
		/// <summary>
		/// Handle to parent workspace.
		/// </summary>
		public Workspace workspace = null;
		#endregion

		#region Windows Generated Vars
		private System.Windows.Forms.ListBox AvailableImages;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		#endregion

		#region Constructor
		/// <summary>
		/// Obtains a handle to the parent workspace.
		/// Populates the list box with the ImageContainers
		/// within the workspace.
		/// </summary>
		/// <param name="Parent"></param>
		public ImageList(Workspace Parent)
		{
			InitializeComponent();
			workspace = Parent;
			AvailableImages.Items.AddRange(Parent.imageContainers.ToArray());
		}
		#endregion

		#region Dispose Operation
		/// <summary>
		/// Clean up any resources being used.
		/// Verify that the Form is no longer
		/// being used, if so then dispose,
		/// otherwise just hide it.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if(workspace.closing)
			{
				if( disposing )
				{
					if(components != null)
					{
						components.Dispose();
					}
				}
				base.Dispose( disposing );
			}
			else
			{
				Hide();
			}
		}
		#endregion

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.AvailableImages = new System.Windows.Forms.ListBox();
			this.SuspendLayout();
			// 
			// AvailableImages
			// 
			this.AvailableImages.Dock = System.Windows.Forms.DockStyle.Fill;
			this.AvailableImages.Location = new System.Drawing.Point(0, 0);
			this.AvailableImages.Name = "AvailableImages";
			this.AvailableImages.Size = new System.Drawing.Size(292, 264);
			this.AvailableImages.TabIndex = 0;
			this.AvailableImages.MouseDown += new System.Windows.Forms.MouseEventHandler(this.AvailableImages_MouseDown);
			// 
			// ImageList
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(292, 266);
			this.Controls.Add(this.AvailableImages);
			this.Name = "ImageList";
			this.Text = "Images";
			this.ResumeLayout(false);

		}
		#endregion

		#region Item Selection Handler
		/// <summary>
		/// Display the ImageContainer that
		/// is clicked within the window.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void AvailableImages_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			int index = AvailableImages.IndexFromPoint(e.X,e.Y);
			if(index>=0)
			{
				ImageContainer ic = (ImageContainer)AvailableImages.Items[index];
				ic.Show();
				ic.Refresh();
				ic.Focus();
			}
		}
		#endregion
		
		#region Update List
		/// <summary>
		/// Update the list
		/// with new data.
		/// </summary>
		/// <param name="Images"></param>
		public void updateList(ArrayList Images)
		{
			AvailableImages.Items.Clear();
			AvailableImages.Items.AddRange(Images.ToArray());
		}
		#endregion
	}
}
